package com.example.sefinsa_app.controllers;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Looper;
import android.provider.MediaStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.bumptech.glide.Glide;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.*;
import retrofit2.converter.gson.GsonConverterFactory;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

import retrofit2.Call;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;

public class RMDController {

    private static final Logger log = LoggerFactory.getLogger(RMDController.class);
    private final DatabaseHelper databaseHelper;
    private final SQLiteDatabase wdb;
    private final SQLiteDatabase rdb;
    private final Context context;
    private final Activity activity;
    private final VolleyS vs;
    private static RequestQueue rq = null;

    public RMDController(Context context, Activity activity) {
        this.context = context;
        this.activity = activity;
        databaseHelper = new DatabaseHelper(this.context);
        wdb = databaseHelper.getWritableDatabase();
        rdb = databaseHelper.getReadableDatabase();

        if (activity != null) {
            getCurrentLocation(activity);
        }

        vs = new VolleyS(this.context);
        rq = vs.getRequestQueue();

        // wdb.execSQL("DROP TABLE rmds;"); wdb.execSQL("DROP TABLE rmds_usuarios;"); wdb.execSQL("DROP TABLE rmd_articulos;"); wdb.execSQL("DROP TABLE fotos_articulo;");

        String createRMDSTable = "CREATE TABLE IF NOT EXISTS rmds(id INT PRIMARY KEY, prestamo_id INT, valor_garantia DECIMAL(10, 2), pagara DECIMAL(10, 2), fecha VARCHAR(10), recibe_mercancia VARCHAR(200), firma_cliente VARCHAR(2000000), firma_asesor VARCHAR(2000000), fecha_pago VARCHAR(10), sync INTEGER DEFAULT 0)";

        String createRMDUsuariosTable = "CREATE TABLE IF NOT EXISTS rmds_usuarios(rmd_id INT PRIMARY KEY, usuario_id INT)";

        String createRMDArticulosTable = "CREATE TABLE IF NOT EXISTS rmd_articulos(id INTEGER PRIMARY KEY AUTOINCREMENT, rmd_id INT, articulo VARCHAR(100), marca VARCHAR(100), color VARCHAR(100), detalles_condiciones VARCHAR(1000))";

        String createArticulosFotosTable = "CREATE TABLE IF NOT EXISTS fotos_articulo(id INTEGER PRIMARY KEY AUTOINCREMENT, articulo_id int, ruta varchar(200000))";

        wdb.execSQL(createRMDSTable);
        wdb.execSQL(createRMDUsuariosTable);
        wdb.execSQL(createRMDArticulosTable);
        wdb.execSQL(createArticulosFotosTable);
    }

    /*
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     *                           FUNCIONES PARA BASE DE DATOS LOCAL
     * */

    public RMD getDatosBaseRMD(String prestamoId) {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "clientes.telefono, " +
                "rutas.nombre_ruta, " +
                "poblaciones.nombre_poblacion " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON clientes.id = prestamos.cliente_id " +
                "JOIN rutas ON rutas.id = clientes.ruta_id " +
                "JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                "WHERE " +
                "prestamos.id = ?";

        Cursor cursor = rdb.rawQuery(query, new String[]{prestamoId});

        if (cursor.moveToFirst()) {
            String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
            String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
            String ruta = cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta"));
            String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));

            RMD rmdBase = new RMD(prestamoId, numeroCuenta, nombre, telefono, ruta, poblacion);

            return rmdBase;
        } else {
            return null;
        }
    }

    public String getRMDSCount(String empelado_id) {
        String query = "SELECT COUNT(*) FROM rmds_usuarios WHERE usuario_id = ?";
        Cursor cursor = rdb.rawQuery(query, new String[]{empelado_id});

        if (cursor.moveToFirst()) {
            int count = cursor.getInt(0);
            return String.valueOf(count);
        } else {
            return "0";
        }
    }

    public void prepararRMDSBDLocal(String id, String usuarioId, prerararRMDSBDLocalCallback callback) {
        String query = "INSERT INTO rmds_usuarios (rmd_id, usuario_id) VALUES (?, ?)";
        wdb.execSQL(query, new String[]{id, usuarioId});
        callback.onSucess();
    }

    public String getPrimerRMDId(String usuario_id) {
        String query = "SELECT MIN(rmd_id) FROM rmds_usuarios WHERE usuario_id = ?";
        Cursor cursor = rdb.rawQuery(query, new String[]{usuario_id});

        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        } else {
            return null;
        }
    }

    public void postRMD(RMD rmd, String prestamoId, prerararRMDSCallback callback) {
        try {
            String folio = rmd.getId();
            ArrayList<Articulo> articulos = rmd.getArticulos();
            String valorGarantia = rmd.getValorGarantia();
            String pagara = rmd.getPagara();
            String fecha = rmd.getFecha();
            String firmaCliente = rmd.getFirmaCliente();
            String firmaAsesor = rmd.getFirmaAsesor();
            String recibeMercancia = rmd.getRecibeMercancia();
            String fechaPago = rmd.getFechaIns();

            String queryRMD = "INSERT INTO rmds (id, prestamo_id, valor_garantia, pagara, fecha, firma_cliente, firma_asesor, recibe_mercancia, fecha_pago) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            wdb.execSQL(queryRMD, new String[]{folio, prestamoId, valorGarantia, pagara, fecha, firmaCliente, firmaAsesor, recibeMercancia, fechaPago});

            for (Articulo articulo : articulos) {
                String nombreArticulo = articulo.getArticulo();
                String marca = articulo.getMarca();
                String color = articulo.getColor();
                String detallesCondiciones = articulo.getDetalleCondiciones();
                ArrayList<Bitmap> imagenes = articulo.getImagenes();

                String queryArticulo = "INSERT INTO rmd_articulos (rmd_id, articulo, marca, color, detalles_condiciones) VALUES (?, ?, ?, ?, ?)";
                wdb.execSQL(queryArticulo, new String[]{folio, nombreArticulo, marca, color, detallesCondiciones});

                String queryLtsArticulo = "SELECT id FROM rmd_articulos ORDER BY id DESC LIMIT 1";
                Cursor cursor = rdb.rawQuery(queryLtsArticulo, null);

                if (cursor.moveToFirst()) {
                    String articuloId = cursor.getString(0);

                    String queryFotosArticulo = "INSERT INTO fotos_articulo (articulo_id, ruta) VALUES (?, ?)";
                    if (!articulo.getUrisImagenes().isEmpty()) {
                        for (Uri uri : articulo.getUrisImagenes()) {
                            wdb.execSQL(queryFotosArticulo, new String[]{articuloId, uri.toString()});
                        }
                    }
                }
            }
            String queryDeleteUserRMD = "DELETE FROM rmds_usuarios WHERE rmd_id = ?";
            wdb.execSQL(queryDeleteUserRMD, new String[]{folio});
            callback.onSuccess("RMD agregado correctamente");
        } catch (Exception e) {
            callback.onError(e.getMessage());
        }
    }

    public void intertarRMDServidor(RMD rmd, SincronizarDelServidorCallback callback) {
        String id = rmd.getId();
        String prestamoId = rmd.getPrestamo_id();
        String valorGarantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fecha = rmd.getFecha();
        String firmaCliente = rmd.getFirmaCliente();
        String firmaAsesor = rmd.getFirmaAsesor();
        String recibeMercancia = rmd.getRecibeMercancia();
        String fechaPago = rmd.getFechaIns();

        ArrayList<Articulo> articulos = rmd.getArticulos();

        String query = "INSERT INTO rmds (id, prestamo_id, valor_garantia, pagara, fecha, firma_cliente, firma_asesor, recibe_mercancia, fecha_pago) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        wdb.execSQL(query, new String[]{id, prestamoId, valorGarantia, pagara, fecha, firmaCliente, firmaAsesor, recibeMercancia, fechaPago});

        String querySync = "UPDATE rmds SET sync = 1 WHERE id = ?";
        wdb.execSQL(querySync, new String[]{id});

        if (articulos != null && !articulos.isEmpty()) {
            for (Articulo articulo : articulos) {
                String nombreArticulo = articulo.getArticulo();
                String marca = articulo.getMarca();
                String color = articulo.getColor();
                String detallesCondiciones = articulo.getDetalleCondiciones();
                Log.d("askldlas", nombreArticulo);

                String queryArticulo = "INSERT INTO rmd_articulos (rmd_id, articulo, marca, color, detalles_condiciones) VALUES (?, ?, ?, ?, ?)";
                wdb.execSQL(queryArticulo, new String[]{id, nombreArticulo, marca, color, detallesCondiciones});
                callback.onSuccess();
            }
        } else {
            callback.onSuccess();
        }
    }

    public static Bitmap escalarBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width < 1000 && height < 1000) {
            return bitmap;
        }

        int proporcion = 8;

        int newWidth = width / proporcion;
        int newHeight = height / proporcion;
        Log.d("bitmapsizenuevo", newWidth + " " + newHeight);
        return Bitmap.createScaledBitmap(bitmap, newWidth, newHeight, false);
    }

    public ArrayList<RMD> indexRMD() {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.id, " +
                "rmds.fecha " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                "JOIN rmds ON rmds.prestamo_id = prestamos.id " +
                "ORDER BY rmds.id DESC";

        Cursor cursor = rdb.rawQuery(query, null);

        if (cursor.moveToFirst()) {
            ArrayList<RMD> rmds = new ArrayList<>();

            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));

                rmds.add(new RMD(id, numeroCuenta, nombre, poblacion, fecha));

            } while (cursor.moveToNext());

            return rmds;
        }
        return null;
    }

    public RMD getRMD(String id) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rutas.nombre_ruta, rmds.valor_garantia, rmds.pagara, rmds.fecha, rmds.recibe_mercancia, rmds.firma_cliente, rmds.firma_asesor, rmds.fecha_pago FROM prestamos JOIN rmds ON rmds.prestamo_id = prestamos.id JOIN clientes ON clientes.id = prestamos.cliente_id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rutas ON poblaciones.ruta_id = rutas.id WHERE rmds.id = ?";
        Cursor cursor = rdb.rawQuery(query, new String[]{id});

        if (cursor.moveToFirst()) {
            String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
            String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
            String ruta = cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta"));
            String valorGarantia = cursor.getString(cursor.getColumnIndexOrThrow("valor_garantia"));
            String pagara = cursor.getString(cursor.getColumnIndexOrThrow("pagara"));
            String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
            String recibeMercancia = cursor.getString(cursor.getColumnIndexOrThrow("recibe_mercancia"));
            String firmaCliente = cursor.getString(cursor.getColumnIndexOrThrow("firma_cliente"));
            String firmaAsesor = cursor.getString(cursor.getColumnIndexOrThrow("firma_asesor"));
            String fechaPago = cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago"));

            return new RMD(id, numeroCuenta, nombre, poblacion, ruta, valorGarantia, pagara, fecha, recibeMercancia, firmaCliente, firmaAsesor, fechaPago);
        }
        return null;
    }

    public ArrayList<Articulo> getArticulos(String id) {
        String query = "SELECT * FROM rmd_articulos WHERE rmd_id = ?";
        Cursor cursor = rdb.rawQuery(query, new String[]{id});

        if (cursor.moveToFirst()) {
            ArrayList<Articulo> articulos = new ArrayList<>();
            do {
                String articulo = cursor.getString(cursor.getColumnIndexOrThrow("articulo"));
                String marca = cursor.getString(cursor.getColumnIndexOrThrow("marca"));
                String color = cursor.getString(cursor.getColumnIndexOrThrow("color"));
                String detallesCondiciones = cursor.getString(cursor.getColumnIndexOrThrow("detalles_condiciones"));

                Articulo articuloObj = new Articulo(articulo, marca, color, detallesCondiciones);

                articulos.add(articuloObj);
            } while (cursor.moveToNext());
            return articulos;
        } else {
            return null;
        }
    }

    public RMD getRMDParaImpresion(String folio) {
        String query = "SELECT " +
                "rmds.id, " +
                "rmds.fecha, " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "clientes.telefono, " +
                "rutas.nombre_ruta, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.valor_garantia, " +
                "rmds.pagara, " +
                "rmds.fecha_pago, " +
                "rmds.firma_cliente, " +
                "rmds.firma_asesor, " +
                "rmds.recibe_mercancia " +
                "FROM " +
                "prestamos " +
                "JOIN rmds ON prestamos.id = rmds.prestamo_id " +
                "JOIN clientes ON clientes.id = prestamos.cliente_id " +
                "JOIN rutas ON rutas.id = clientes.ruta_id " +
                "JOIN poblaciones on poblaciones.id = clientes.poblacion_id " +
                "WHERE " +
                "rmds.id = ?";

        Cursor cursor = rdb.rawQuery(query, new String[]{folio});

        String queryArticulos = "SELECT * FROM rmd_articulos WHERE rmd_articulos.rmd_id = ?";

        Cursor cursorArticulos = rdb.rawQuery(queryArticulos, new String[]{folio});

        if (cursor.moveToFirst()) {
            String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
            String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
            String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
            String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
            String ruta = cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta"));
            String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
            String valorGarantia = cursor.getString(cursor.getColumnIndexOrThrow("valor_garantia"));
            String pagara = cursor.getString(cursor.getColumnIndexOrThrow("pagara"));
            String fechaPago = cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago"));
            String firmaCliente = cursor.getString(cursor.getColumnIndexOrThrow("firma_cliente"));
            String firmaAsesor = cursor.getString(cursor.getColumnIndexOrThrow("firma_asesor"));
            String recibeMercancia = cursor.getString(cursor.getColumnIndexOrThrow("recibe_mercancia"));

            ArrayList<Articulo> articulos = new ArrayList<>();

            if (cursorArticulos.moveToFirst()) {
                do {
                    String articulo = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("articulo"));
                    String marca = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("marca"));
                    String color = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("color"));
                    String detallesCondiciones = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("detalles_condiciones"));

                    Articulo articuloObj = new Articulo(articulo, marca, color, detallesCondiciones);

                    articulos.add(articuloObj);
                } while (cursorArticulos.moveToNext());
            }

            return new RMD(id, numeroCuenta, nombre, ruta, poblacion, fecha, articulos, valorGarantia, pagara, fechaPago, firmaCliente, firmaAsesor, recibeMercancia, telefono);
        }
        return null;
    }

    public ArrayList<RMD> getRMDsDesincronizados() {
        String query = "SELECT * FROM rmds WHERE sync = 0";
        Cursor cursor = rdb.rawQuery(query, null);
        ArrayList<RMD> rmds = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String prestamo_id = cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id"));
                String valor_garantia = cursor.getString(cursor.getColumnIndexOrThrow("valor_garantia"));
                String pagara = cursor.getString(cursor.getColumnIndexOrThrow("pagara"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                String fecha_pago = cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago"));
                String firma_cliente = cursor.getString(cursor.getColumnIndexOrThrow("firma_cliente"));
                String firma_asesor = cursor.getString(cursor.getColumnIndexOrThrow("firma_asesor"));
                String recibe_mercancia = cursor.getString(cursor.getColumnIndexOrThrow("recibe_mercancia"));

                String queryArticulos = "SELECT * FROM rmd_articulos WHERE rmd_id = ?";
                Cursor cursorArticulos = rdb.rawQuery(queryArticulos, new String[]{id});

                ArrayList<Articulo> articulos = new ArrayList<>();

                if (cursorArticulos.moveToFirst()) {
                    do {
                        String id_articulo = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("id"));
                        String articulo = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("articulo"));
                        String marca = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("marca"));
                        String color = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("color"));
                        String detalles_condiciones = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("detalles_condiciones"));

                        ArrayList<Uri> rutas = new ArrayList<>();
                        String queryRutas = "SELECT * FROM fotos_articulo WHERE articulo_id = ?";
                        Cursor cursorRutas = rdb.rawQuery(queryRutas, new String[]{id_articulo});

                        if (cursorRutas.moveToFirst()) {
                            do {
                                String ruta = cursorRutas.getString(cursorRutas.getColumnIndexOrThrow("ruta"));
                                rutas.add(Uri.parse(ruta));
                            } while (cursorRutas.moveToNext());
                        }
                        cursorRutas.close();

                        Articulo articuloObj = new Articulo(articulo, marca, color, detalles_condiciones, null, rutas);
                        articulos.add(articuloObj);
                    } while (cursorArticulos.moveToNext());
                }
                cursorArticulos.close();

                rmds.add(new RMD(id, prestamo_id, valor_garantia, pagara, fecha, fecha_pago, firma_cliente, firma_asesor, recibe_mercancia, articulos));
            } while (cursor.moveToNext());
        }
        cursor.close();
        return rmds;
    }

    public int getRMDSCount() {
        String query = "SELECT COUNT(*) FROM rmds";
        Cursor cursor = rdb.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            int count = cursor.getInt(0);
            return count;
        }
        return 0;
    }

    public String getAllRMDSIds() {
        String query = "SELECT id FROM rmds";
        Cursor cursor = rdb.rawQuery(query, null);

        if (cursor.moveToFirst()) {
            String ids = "";
            do {
                ids += cursor.getString(0) + ",";
            } while (cursor.moveToNext());
            return ids.substring(0, ids.length() - 1);
        }
        return "";
    }

    /*
     *                           FILTROS
     *                           FILTROS
     *                           FILTROS
     *                           FILTROS
     *                           FILTROS
     *                           FILTROS
     *                           FILTROS
     * */

    public ArrayList<RMD> filtroFecha(String fechaFiltro) {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.id, " +
                "rmds.fecha " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                "JOIN rmds ON rmds.prestamo_id = prestamos.id " +
                "WHERE " +
                "rmds.fecha = ? " +
                "ORDER BY rmds.id DESC";
        Cursor cursor = rdb.rawQuery(query, new String[]{fechaFiltro});
        ArrayList<RMD> rmds = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));

                rmds.add(new RMD(id, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroRutaFecha(String fechaFiltro, String rutaFiltro) {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.id, " +
                "rmds.fecha " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                "JOIN rmds ON rmds.prestamo_id = prestamos.id " +
                "WHERE " +
                "rmds.fecha = ? " +
                "AND clientes.ruta_id = ?" +
                "ORDER BY rmds.id DESC";
        Cursor cursor = rdb.rawQuery(query, new String[]{fechaFiltro, rutaFiltro});
        ArrayList<RMD> rmds = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));

                rmds.add(new RMD(id, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroPoblacionFecha(String fechaFiltro, String poblacionFiltro) {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.id, " +
                "rmds.fecha " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                "JOIN rmds ON rmds.prestamo_id = prestamos.id " +
                "WHERE " +
                "rmds.fecha = ? " +
                "AND clientes.poblacion_id = ?" +
                "ORDER BY rmds.id DESC";
        Cursor cursor = rdb.rawQuery(query, new String[]{fechaFiltro, poblacionFiltro});
        ArrayList<RMD> rmds = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));

                rmds.add(new RMD(id, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroNombre(String nombreFiltro) {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.id, " +
                "rmds.fecha " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                "JOIN rmds ON rmds.prestamo_id = prestamos.id " +
                "WHERE " +
                "clientes.nombre_completo LIKE ? " +
                "ORDER BY rmds.id DESC";
        Cursor cursor = rdb.rawQuery(query, new String[]{"%" + nombreFiltro + "%"});
        ArrayList<RMD> rmds = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));

                rmds.add(new RMD(id, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroFolio(String folioFiltro) {
        String query = "SELECT " +
                "prestamos.numero_tarjeton, " +
                "clientes.nombre_completo, " +
                "poblaciones.nombre_poblacion, " +
                "rmds.id, " +
                "rmds.fecha " +
                "FROM " +
                "prestamos " +
                "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                "JOIN rmds ON rmds.prestamo_id = prestamos.id " +
                "WHERE " +
                "rmds.id LIKE ? " +
                "ORDER BY rmds.id DESC";
        Cursor cursor = rdb.rawQuery(query, new String[]{"%" + folioFiltro + "%"});
        ArrayList<RMD> rmds = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));

                rmds.add(new RMD(id, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    /*
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     *                          FUNCIONES PARA REQUESTS AL SERVIDOR
     * */

    public String ruta = API.urlPrestamos;

    public void getCountRMDsServidor(GetCountRMDsServidorCallback callback) {
        JSONObject data = new JSONObject();
        final int[] count = {0};

        try {
            data.put("func", "getRMDCount");
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, ruta, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            count[0] = response.getInt("data");
                            callback.onSuccess(count[0]);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        callback.onError(error.getMessage());
                    }
                });
        rq.add(req);
    }

    public void prepararRMDS(String cantidad, String usuarioId, prerararRMDSCallback callback) {
        JSONObject data = new JSONObject();

        try {
            data.put("func", "prepararRMDS");
            data.put("cantidad", cantidad);
            data.put("usuario_id", usuarioId);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, ruta, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        JSONArray data = response.optJSONArray("data");

                        for (int i = 0; i < data.length(); i++) {
                            String rmd_id = data.optJSONObject(i).optString("rmd_id");
                            String usuario_id = data.optJSONObject(i).optString("usuario_id");
                            prepararRMDSBDLocal(rmd_id, usuario_id, new prerararRMDSBDLocalCallback() {
                                @Override
                                public void onSuccess(String response) {
                                    callback.onSuccess(response);
                                }

                                @Override
                                public void onError(String error) {
                                    callback.onError(error);
                                }

                                @Override
                                public void onSucess() {
                                    callback.onSucess();
                                }
                            });
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

        rq.add(req);
    }

    public interface ApiService {
        @Multipart
        @POST("Prestamos/FotosRMD.php")
        Call<ResponseBody> subirFoto(
                @Part("rmd_id") RequestBody rmdId,
                @Part MultipartBody.Part file
        );
    }

    public static File bitmapToFile(Context context, Bitmap bitmap, String fileName) {
        File file = new File(context.getCacheDir(), fileName);
        try (FileOutputStream fos = new FileOutputStream(file)) {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, fos);
            fos.flush();
            return file;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void subirFotoRetrofit(Context context, String rmdId, Bitmap bitmap, String articuloId) {
        Bitmap bitmapEscalado = escalarBitmap(bitmap);
        File file = bitmapToFile(context, bitmapEscalado, "foto_" + System.currentTimeMillis() + ".jpg");
        if (file == null) {
            Log.e("RetrofitUpload", "Error al crear archivo desde bitmap");
            return;
        }

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        ApiService apiService = retrofit.create(ApiService.class);

        RequestBody rmdIdBody = RequestBody.create(MediaType.parse("text/plain"), rmdId);

        RequestBody requestFile = RequestBody.create(MediaType.parse("image/jpeg"), file);
        MultipartBody.Part body = MultipartBody.Part.createFormData("file", file.getName(), requestFile);

        Call<ResponseBody> call = apiService.subirFoto(rmdIdBody, body);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
                String responseString = null;
                try {
                    responseString = response.body().string();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Log.d("retrofitResp", responseString);

                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(responseString);
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                JSONObject dataObject = null;
                try {
                    dataObject = jsonObject.getJSONObject("data");
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                String imageUrl = null;
                try {
                    imageUrl = dataObject.getString("url");
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }

                Log.d("retrofitResp", "Image URL: " + imageUrl);
                postRutasFotos(articuloId, imageUrl);
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                Log.e("RetrofitUpload", "Error en llamada Retrofit", t);
            }
        });
    }

    public void subirRMDServidor(RMD rmd, String prestamoId) {
        String id = rmd.getId();
        String prestamo_id = prestamoId;
        String valor_garantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fecha = rmd.getFecha();
        String fecha_pago = rmd.getFechaIns();
        String firma_cliente = rmd.getFirmaCliente();
        String firma_asesor = rmd.getFirmaAsesor();
        String recibe_mercancia = rmd.getRecibeMercancia();

        ArrayList<Articulo> articulos = rmd.getArticulos();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "postRMD");
            data.put("id", id);
            data.put("prestamo_id", prestamo_id);
            data.put("valor_garantia", valor_garantia);
            data.put("pagara", pagara);
            data.put("fecha", fecha);
            data.put("recibe_mercancia", recibe_mercancia);
            data.put("firma_cliente", firma_cliente);
            data.put("firma_asesor", firma_asesor);
            data.put("fecha_pago", fecha_pago);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        String query = "UPDATE rmds SET sync = 1 WHERE id = ?";
                        rdb.execSQL(query, new String[]{id});

                        for (Articulo articulo : articulos) {
                            postArticulos(articulo, id, context);
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

        rq.add(req);
    }

    public static void postArticulos(Articulo articulos, String rmdId, Context context) {
        String rmd_id = rmdId;
        String articulo = articulos.getArticulo();
        String marca = articulos.getMarca();
        String color = articulos.getColor();
        String detalles_condiciones = articulos.getDetalleCondiciones();
        ArrayList<Bitmap> imagenes = articulos.getImagenes();

        JSONObject data = new JSONObject();

        try {
            data.put("func", "postArticulo");
            data.put("rmd_id", rmd_id);
            data.put("articulo", articulo);
            data.put("marca", marca);
            data.put("color", color);
            data.put("detalles_condiciones", detalles_condiciones);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        String articulo_id = response.optString("data");
                        Log.d("responsePostArticulos", articulo_id);

                        for (Bitmap bitmap : imagenes) {
                            subirFotoRetrofit(context, rmd_id, bitmap, articulo_id);
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

        rq.add(req);
    }

    public static void postRutasFotos(String articulo_id, String ruta) {
        JSONObject data = new JSONObject();

        try {
            data.put("func", "postRutasFotos");
            data.put("articulo_id", articulo_id);
            data.put("ruta", ruta);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) { }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) { }
                });

        rq.add(req);
    }

    public void getRutasFotosFromServer(String rmdId, String articulo) {
        JSONObject data = new JSONObject();

        try {
            data.put("func", "getRutasFotos");
            data.put("articulo_id", rmdId);
            data.put("articulo", articulo);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    public void onResponse(JSONObject response) {
                        JSONArray data = response.optJSONArray("data");
                        ArrayList<String> rutas = new ArrayList<>();

                        for (int i = 0; i < data.length(); i++) {
                            String ruta = data.optJSONObject(i).optString("ruta");
                            rutas.add(ruta);
                        }

                        Log.d("rutasalskdlkasl", rutas.toString());

                        if (rutas.isEmpty()) {
                            Toast.makeText(context, "El artículo no tiene imágenes", Toast.LENGTH_SHORT).show();
                        } else {
                            AlertDialog.Builder builder = new AlertDialog.Builder(context);
                            builder.setTitle("Imágenes del artículo");

                            View dialogLayout = LayoutInflater.from(context).inflate(R.layout.ver_imagenes_articulos, null);
                            builder.setView(dialogLayout);

                            ImageView imgVw1 = dialogLayout.findViewById(R.id.imgVw1);
                            ImageView imgVw2 = dialogLayout.findViewById(R.id.imgVw2);

                            if (rutas.size() == 1) {
                                String ruta1 = rutas.get(0);
                                Glide.with(context).load(ruta1).into(imgVw1);
                            } else if (rutas.size() == 2) {
                                String ruta1 = rutas.get(0);
                                String ruta2 = rutas.get(1);
                                Glide.with(context).load(ruta1).into(imgVw1);
                                Glide.with(context).load(ruta2).into(imgVw2);
                            }

                            builder.setPositiveButton("Cerrar", null);
                            AlertDialog dialog = builder.create();
                            dialog.show();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

        rq.add(req);
    }

    public void subirRMDsDesincronizadosServidor(RMD rmd, SubirRMDsDesincronizadosServidorCallback callback) {
        String id = rmd.getId();
        String prestamo_id = rmd.getPrestamo_id();
        String valor_garantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fecha = rmd.getFecha();
        String fecha_pago = rmd.getFechaIns();
        String firma_cliente = rmd.getFirmaCliente();
        String firma_asesor = rmd.getFirmaAsesor();
        String recibe_mercancia = rmd.getRecibeMercancia();

        Log.d("ddid", id);
        Log.d("ddprestamo_id", prestamo_id);
        Log.d("ddvalor_garantia", valor_garantia);
        Log.d("ddpagara", pagara);
        Log.d("ddfecha", fecha);
        Log.d("ddfecha_pago", fecha_pago);
        Log.d("ddfirma_cliente", firma_cliente);
        Log.d("ddfirma_asesor", firma_asesor);
        Log.d("ddrecibe_mercancia", recibe_mercancia);

        ArrayList<Articulo> articulos = rmd.getArticulos();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "postRMD");
            data.put("id", id);
            data.put("prestamo_id", prestamo_id);
            data.put("valor_garantia", valor_garantia);
            data.put("pagara", pagara);
            data.put("fecha", fecha);
            data.put("recibe_mercancia", recibe_mercancia);
            data.put("firma_cliente", firma_cliente);
            data.put("firma_asesor", firma_asesor);
            data.put("fecha_pago", fecha_pago);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        String query = "UPDATE rmds SET sync = 1 WHERE id = ?";
                        rdb.execSQL(query, new String[]{id});

                        final int[] c = {0};
                        for (Articulo articulo : articulos) {
                            postArticulosDesinconizados(articulo, id, context, activity, new PostArticulosDesinconizadosCallback() {
                                @Override
                                public void onSuccess() {
                                    c[0]++;

                                    Log.d("asdsdasd", c[0] + "/" + articulos.size());

                                    if (c[0] == articulos.size()) {
                                        callback.onSuccess();
                                    }
                                }

                                @Override
                                public void onError(String error) {

                                }
                            });
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        Log.d("ERRORRMDSV", String.valueOf(error));
                    }
                });

        rq.add(req);
    }

    public static void postArticulosDesinconizados(Articulo articulos, String rmdId, Context context, Activity activity, PostArticulosDesinconizadosCallback callback) {
        String rmd_id = rmdId;
        String articulo = articulos.getArticulo();
        String marca = articulos.getMarca();
        String color = articulos.getColor();
        String detalles_condiciones = articulos.getDetalleCondiciones();
        ArrayList<Uri> imagenes = articulos.getUrisImagenes();

        JSONObject data = new JSONObject();

        try {
            data.put("func", "postArticulo");
            data.put("rmd_id", rmd_id);
            data.put("articulo", articulo);
            data.put("marca", marca);
            data.put("color", color);
            data.put("detalles_condiciones", detalles_condiciones);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        String articulo_id = response.optString("data");
                        Log.d("responsePostArticulos", articulo_id);

                        final int[] c = {0};

                        if (imagenes != null && !imagenes.isEmpty()) {
                            int totalImagenesValidas = 0;

                            for (Uri uri : imagenes) {
                                if (!uriExiste(context, uri)) {
                                    Log.w("URI", "La imagen no existe o no se puede acceder: " + uri.toString());
                                    continue;
                                }

                                totalImagenesValidas++;

                                try {
                                    int finalTotalImagenesValidas = totalImagenesValidas;
                                    subirFotoRetrofitDesdeUri(context, rmd_id, uri, articulo_id, activity, new SubirFotoRetrofitDesdeUriCallback() {
                                        @Override
                                        public void onSuccess() {
                                            c[0]++;
                                            if (c[0] == finalTotalImagenesValidas) {
                                                callback.onSuccess();
                                            }
                                        }

                                        @Override
                                        public void onError(String error) {
                                            callback.onError(error);
                                        }
                                    });
                                } catch (IOException e) {
                                    Log.e("SubirFoto", "IOException al subir imagen: " + uri.toString(), e);
                                }
                            }

                            // Si ninguna imagen era válida
                            if (totalImagenesValidas == 0) {
                                Toast.makeText(context, "No se pudo subir ninguna imagen (archivos no encontrados)", Toast.LENGTH_LONG).show();
                                callback.onSuccess();
                            }

                        } else {
                            callback.onSuccess();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // Manejo de error aquí
                    }
                }
        );

        rq.add(req);
    }

    private static boolean uriExiste(Context context, Uri uri) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                inputStream.close();
                return true;
            }
        } catch (FileNotFoundException e) {
            Log.e("uriExiste", "Archivo no encontrado: " + uri.toString());
        } catch (IOException e) {
            Log.e("uriExiste", "Error al cerrar InputStream: " + uri.toString());
        }
        return false;
    }

    public static void subirFotoRetrofitDesdeUri(Context context, String rmdId, Uri uri, String articuloId, Activity activity, SubirFotoRetrofitDesdeUriCallback callback) throws IOException {
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        Bitmap original = BitmapFactory.decodeStream(inputStream);
        if (inputStream != null) {
            inputStream.close();
        }

        Bitmap mutableBitmap = original.copy(Bitmap.Config.ARGB_8888, true);

        mutableBitmap = agregarFechaYUbicacionAImagen(mutableBitmap, activity);

        Bitmap bitmapEscalado = escalarBitmap(mutableBitmap);
        File file = bitmapToFile(context, bitmapEscalado, "foto_" + System.currentTimeMillis() + ".jpg");
        if (file == null) {
            Log.e("RetrofitUpload", "Error al crear archivo desde bitmap");
            return;
        }

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        ApiService apiService = retrofit.create(ApiService.class);

        RequestBody rmdIdBody = RequestBody.create(MediaType.parse("text/plain"), rmdId);

        RequestBody requestFile = RequestBody.create(MediaType.parse("image/jpeg"), file);
        MultipartBody.Part body = MultipartBody.Part.createFormData("file", file.getName(), requestFile);

        Call<ResponseBody> call = apiService.subirFoto(rmdIdBody, body);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
                String responseString = null;
                try {
                    responseString = response.body().string();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Log.d("retrofitResp", responseString);

                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(responseString);
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                JSONObject dataObject = null;
                try {
                    dataObject = jsonObject.getJSONObject("data");
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                String imageUrl = null;
                try {
                    imageUrl = dataObject.getString("url");
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                callback.onSuccess();

                Log.d("retrofitResp", "Image URL: " + imageUrl);
                postRutasFotos(articuloId, imageUrl);

            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                Log.e("RetrofitUpload", "Error en llamada Retrofit", t);
            }
        });
    }

    public void getRMDSinSincronizar(GetRMDsSinSincronizarCallback callback) {
        String excluidos = getAllRMDSIds();
        ArrayList<RMD> rmds = new ArrayList<>();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getRMDSParaSinconizar");
            data.put("excluidos", excluidos);
        } catch (Exception e) { }

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        JSONArray data = response.optJSONArray("data");
                        if (data == null) {
                            callback.onSuccess(rmds);
                            return;
                        }

                        int total = data.length();
                        if (total == 0) {
                            callback.onSuccess(rmds);
                            return;
                        }

                        AtomicInteger respuestasRecibidas = new AtomicInteger(0);

                        for (int i = 0; i < total; i++) {
                            JSONObject rmdJson = data.optJSONObject(i);
                            String id = rmdJson.optString("id");
                            String prestamo_id = rmdJson.optString("prestamo_id");
                            String valor_garantia = rmdJson.optString("valor_garantia");
                            String pagara = rmdJson.optString("pagara");
                            String fecha = rmdJson.optString("fecha");
                            String fecha_pago = rmdJson.optString("fecha_pago");
                            String recibe_mercancia = rmdJson.optString("recibe_mercancia");
                            String firma_cliente = rmdJson.optString("firma_cliente");
                            String firma_asesor = rmdJson.optString("firma_asesor");

                            JSONObject data2 = new JSONObject();
                            try {
                                data2.put("func", "getArticulosRMDParaSincronizar");
                                data2.put("rmd_id", id);
                            } catch (Exception e) { }

                            JsonObjectRequest req2 = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data2,
                                    response2 -> {
                                        JSONArray dataA = response2.optJSONArray("data");
                                        ArrayList<Articulo> articulos = new ArrayList<>();

                                        if (dataA != null) {
                                            for (int j = 0; j < dataA.length(); j++) {
                                                JSONObject artJson = dataA.optJSONObject(j);
                                                String articulo = artJson.optString("articulo");
                                                String marca = artJson.optString("marca");
                                                String color = artJson.optString("color");
                                                String detalles_condiciones = artJson.optString("detalles_condiciones");
                                                articulos.add(new Articulo(articulo, marca, color, detalles_condiciones));
                                            }
                                        }

                                        synchronized (rmds) {
                                            rmds.add(new RMD(id, prestamo_id, valor_garantia, pagara, fecha, fecha_pago,
                                                    firma_cliente, firma_asesor, recibe_mercancia, articulos));
                                        }

                                        if (respuestasRecibidas.incrementAndGet() == total) {
                                            callback.onSuccess(rmds);
                                        }
                                    },
                                    error -> {
                                        Log.e("ErrorArticulos", error.toString());
                                        if (respuestasRecibidas.incrementAndGet() == total) {
                                            callback.onSuccess(rmds);
                                        }
                                    }
                            );

                            rq.add(req2);
                        }
                    }
                },
                error -> callback.onError(error.toString())
        );

        rq.add(req);
    }

    public void getRMDsEditados() throws JSONException {
        JSONObject data = new JSONObject();

        data.put("func", "getRMDEditados");

        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        JSONArray data = response.optJSONArray("data");
                        for (int i = 0; i < data.length(); i++) {
                            JSONObject rmdJson = data.optJSONObject(i);
                            String id = rmdJson.optString("id");
                            String valor_garantia = rmdJson.optString("valor_garantia");
                            String pagara = rmdJson.optString("pagara");
                            String fecha_pago = rmdJson.optString("fecha_pago");
                            String recibeMercancia = rmdJson.optString("recibe_mercancia");

                            String query = "UPDATE rmds SET valor_garantia = ?, pagara = ?, fecha_pago = ?, recibe_mercancia = ? WHERE id = ?";

                            rdb.execSQL(query, new String[]{valor_garantia, pagara, fecha_pago, recibeMercancia, id});
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

        rq.add(req);
    }

    /*
     *                           CALLBACKS
     *                           CALLBACKS
     *                           CALLBACKS
     *                           CALLBACKS
     *                           CALLBACKS
     *                           CALLBACKS
     *                           CALLBACKS
     * */

    public interface CountRMDServidorCallback {
        void onSuccess(int count);
    }

    public interface prerararRMDSBDLocalCallback {
        void onSuccess(String response);
        void onError(String error);
        void onSucess();
    }

    public interface prerararRMDSCallback {
        void onSuccess(String response);
        void onError(String error);
        void onSucess();
    }

    public interface SincronizarDelServidorCallback {
        void onSuccess();
        void onError(String error);
    }

    public interface GetRMDsSinSincronizarCallback {
        void onSuccess(ArrayList<RMD> rmds);
        void onError(String error);
    }

    public interface SubirFotoRetrofitDesdeUriCallback {
        void onSuccess();
        void onError(String error);
    }

    public interface PostArticulosDesinconizadosCallback {
        void onSuccess();
        void onError(String error);
    }

    public interface SubirRMDsDesincronizadosServidorCallback {
        void onSuccess();
        void onError(String error);
    }

    public interface GetCountRMDsServidorCallback {
        void onSuccess(int n);
        void onError(String error);
    }

    /*
     *                           OTROS
     *                           OTROS
     *                           OTROS
     * */

    static String lat = "";
    static String lgt = "";
    private static FusedLocationProviderClient client;

    private static Bitmap agregarFechaYUbicacionAImagen(Bitmap bitmap, Activity activity) {
        addDateTimeToBitmap(bitmap, activity);
        addCoordsToBitmap(bitmap, activity);
        return bitmap;
    }

    private static void addCoordsToBitmap(Bitmap bitmap, Activity activity) {
        client = LocationServices.getFusedLocationProviderClient(activity);
        getCurrentLocation(activity);

        String text = lat + ", " + lgt;

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE);
        textPaint.setTextSize(100);
        textPaint.setAntiAlias(true);

        float textWidth = textPaint.measureText(text);
        float textHeight = textPaint.getTextSize();

        float padding = 10;

        float x = bitmap.getWidth() - textWidth - padding;
        float y = bitmap.getHeight() - padding;

        canvas.drawRect(
                x - padding,
                y - textHeight - padding / 2,
                bitmap.getWidth(),
                bitmap.getHeight(),
                backgroundPaint
        );

        canvas.drawText(text, x, y, textPaint);
    }

    @SuppressLint("MissingPermission")
    private static void getCurrentLocation(Activity activity) {
        LocationManager locationManager = (LocationManager)activity.getSystemService(Context.LOCATION_SERVICE);

        client = LocationServices.getFusedLocationProviderClient(activity);

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                lat = String.valueOf(location.getLatitude());
                                lgt = String.valueOf(location.getLongitude());
                            } else {
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        lat = String.valueOf(location.getLatitude());
                                        lgt = String.valueOf(location.getLongitude());
                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        }
    }

    private static String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private static void addDateTimeToBitmap(Bitmap bitmap, Activity activity) {
        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, bitmap.getHeight() - 110, bitmap.getWidth(), bitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE);
        textPaint.setTextSize(100);
        textPaint.setAntiAlias(true);

        float x = 10;
        float y = bitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }
}
